/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import net.minecraft.class_2583;
import net.minecraft.class_5225;
import team.creative.creativecore.client.render.text.Linebreaker;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.FormattedSingleSink;
import team.creative.creativecore.mixin.StringSplitterAccessor;

public class WidthLimitedCharSink
implements FormattedSingleSink {
    private final class_5225.class_5231 widthProvider;
    private float maxWidth;
    private int position;
    private int[] lastPositions = new int[Linebreaker.values().length];

    public WidthLimitedCharSink(float maxWidth, class_5225 splitter) {
        this.maxWidth = maxWidth;
        this.widthProvider = ((StringSplitterAccessor)splitter).getWidthProvider();
        this.resetPosition();
    }

    @Override
    public boolean accept(int pos, class_2583 style, int character) {
        this.maxWidth -= this.widthProvider.getWidth(character, style);
        for (int i = 0; i < this.lastPositions.length; ++i) {
            if (!Linebreaker.values()[i].predicate.test(Character.valueOf((char)character))) continue;
            this.lastPositions[i] = this.position;
        }
        if (this.maxWidth >= 0.0f) {
            this.position = pos + Character.charCount(character);
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(class_2583 style, AdvancedContent content) {
        this.maxWidth -= (float)content.width(this.widthProvider, style);
        return this.maxWidth >= 0.0f;
    }

    public int getPosition() {
        return this.position;
    }

    public Linebreaker lastBreaker() {
        for (int i = 0; i < this.lastPositions.length; ++i) {
            if (this.lastPositions[i] == -1) continue;
            return Linebreaker.values()[i];
        }
        return null;
    }

    public int lastBreakerPos() {
        for (int i = 0; i < this.lastPositions.length; ++i) {
            if (this.lastPositions[i] == -1) continue;
            return this.lastPositions[i];
        }
        return this.position;
    }

    public void resetPosition() {
        this.position = 0;
        for (int i = 0; i < this.lastPositions.length; ++i) {
            this.lastPositions[i] = -1;
        }
    }
}

